#ifndef _JsonFileEncoder_h__
#define _JsonFileEncoder_h__

#include "transport/GeometryData.h"
#include <GSTenums.h>
#include <buildspec.h>

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

namespace GST
{
namespace Transport
{

#define JsonFileHead_VERSION_MAJOR 1
#define JsonFileHead_VERSION_MINOR 1

class GST_API_EXPORT JsonFileEncoder
{
public:
	JsonFileEncoder();

	void extractGeometryDataFromString(const std::string &in);
	void writeGeometryData(std::ostream &output);

	GeometryData getGeometryData() const
	{
		return metaData;
	}
	void setGeometryData(GeometryData val)
	{
		metaData = val;
	}

protected:
	GeometryData metaData;
};

} // namespace Transport
} // namespace GST

#endif // _JsonFileEncoder_h__
